/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.core.forge;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import icyllis.modernui.ModernUI;
import icyllis.modernui.core.PluginList;
import icyllis.modernui.core.forge.Config;
import icyllis.modernui.core.forge.EventHandler;
import icyllis.modernui.core.forge.ModernUIForge;
import icyllis.modernui.core.forge.MuiHooks;
import icyllis.modernui.core.forge.MuiRegistries;
import icyllis.modernui.core.forge.NetMessages;
import icyllis.modernui.core.forge.NetworkHandler;
import icyllis.modernui.core.forge.ProjectBuilderRenderer;
import icyllis.modernui.core.forge.ServerHandler;
import icyllis.modernui.core.mixin.AccessOption;
import icyllis.modernui.core.mixin.AccessVideoSettingsScreen;
import icyllis.modernui.graphics.B3DRedirector;
import icyllis.modernui.graphics.GLWrapper;
import icyllis.modernui.graphics.shader.program.ArcProgram;
import icyllis.modernui.graphics.shader.program.CircleProgram;
import icyllis.modernui.graphics.shader.program.RectProgram;
import icyllis.modernui.graphics.shader.program.RoundRectProgram;
import icyllis.modernui.graphics.textmc.ModernFontRenderer;
import icyllis.modernui.graphics.textmc.TextLayoutProcessor;
import icyllis.modernui.platform.RenderCore;
import icyllis.modernui.test.TestMenu;
import icyllis.modernui.view.UIManager;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.AbstractOption;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.VideoSettingsScreen;
import net.minecraft.client.settings.IteratableOption;
import net.minecraft.client.settings.SliderPercentageOption;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.extensions.IForgeContainerType;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.network.IContainerFactory;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;

@Mod.EventBusSubscriber(modid="modernui", bus=Mod.EventBusSubscriber.Bus.MOD)
final class Registration {
    private Registration() {
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    static void registerSounds(@Nonnull RegistryEvent.Register<SoundEvent> event) {
        IForgeRegistry registry = event.getRegistry();
        MuiRegistries.BUTTON_CLICK_1 = Registration.registerSound((IForgeRegistry<SoundEvent>)registry, "button1");
        MuiRegistries.BUTTON_CLICK_2 = Registration.registerSound((IForgeRegistry<SoundEvent>)registry, "button2");
    }

    @SubscribeEvent
    static void registerMenus(@Nonnull RegistryEvent.Register<ContainerType<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        MuiRegistries.TEST_MENU = Registration.registerMenu(registry, TestMenu::new, "test");
    }

    @SubscribeEvent
    static void registerItems(@Nonnull RegistryEvent.Register<Item> event) {
        if (ModernUIForge.production) {
            Item.Properties properties = new Item.Properties().func_200917_a(1).setISTER(() -> ProjectBuilderRenderer::new);
            MuiRegistries.PROJECT_BUILDER_ITEM = (Item)new Item(properties).setRegistryName("project_builder");
            event.getRegistry().register((IForgeRegistryEntry)MuiRegistries.PROJECT_BUILDER_ITEM);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    static void loadingClient(ParticleFactoryRegisterEvent event) {
    }

    @SubscribeEvent
    static void setupCommon(@Nonnull FMLCommonSetupEvent event) {
        InputStream stream;
        byte[] protocol = null;
        try {
            stream = ModernUI.class.getClassLoader().getResourceAsStream(NetMessages.class.getName().replace('.', '/') + ".class");
            try {
                Objects.requireNonNull(stream, "Mod file is broken");
                protocol = IOUtils.toByteArray((InputStream)stream);
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            stream = ModernUI.class.getClassLoader().getResourceAsStream(NetMessages.class.getName().replace('.', '/') + "$C.class");
            try {
                Objects.requireNonNull(stream, "Mod file is broken");
                protocol = ArrayUtils.addAll((byte[])protocol, (byte[])IOUtils.toByteArray((InputStream)stream));
            }
            finally {
                if (stream != null) {
                    stream.close();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (ModList.get().getModContainerById(new String(new byte[]{107, 73, 119, 105}, StandardCharsets.UTF_8).toLowerCase(Locale.ROOT)).isPresent()) {
            event.enqueueWork(() -> IVertexBuilder.field_227884_f_.fatal("All {} are {}...", (Object)"things", (Object)"gbing wrbng".replace('b', 'o')));
        }
        protocol = ArrayUtils.addAll((byte[])protocol, (byte[])ModList.get().getModFileById("modernui").getTrustData().map(s2 -> s2.getBytes(StandardCharsets.UTF_8)).orElse(null));
        NetMessages.network = new NetworkHandler("modernui", "main_network", () -> NetMessages::handle, NetMessages::handle, protocol == null ? null : DigestUtils.md5Hex((byte[])protocol), PluginList.get().size() == 0);
        MinecraftForge.EVENT_BUS.register((Object)ServerHandler.INSTANCE);
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    static void setupClient(@Nonnull FMLClientSetupEvent event) {
        ((Minecraft)event.getMinecraftSupplier().get()).func_213165_a(() -> {
            GLWrapper.setRedirector(new B3DRedirector());
            RenderCore.initialize();
            ArcProgram.createPrograms();
            CircleProgram.createPrograms();
            RectProgram.createPrograms();
            RoundRectProgram.createPrograms();
            UIManager.initialize();
            ModernUI.LOGGER.info(ModernUI.MARKER, "UIManager initialized");
            TextLayoutProcessor.getInstance().initRenderer();
            ModernFontRenderer.change((Boolean)Config.CLIENT.globalRenderer.get(), (Boolean)Config.CLIENT.allowShadow.get());
        });
        AccessOption.setGuiScale(new IteratableOption("options.guiScale", (options, integer) -> {
            options.field_74335_Z = Integer.remainderUnsigned(options.field_74335_Z + integer, (MuiHooks.C.calcGuiScales() & 0xF) + 1);
        }, (options, cycleOption) -> options.field_74335_Z == 0 ? ((AccessOption)cycleOption).callGenericValueLabel((ITextComponent)new TranslationTextComponent("options.guiScale.auto").func_230529_a_((ITextComponent)new StringTextComponent(" (" + (MuiHooks.C.calcGuiScales() >> 4 & 0xF) + ")"))) : ((AccessOption)cycleOption).callGenericValueLabel((ITextComponent)new StringTextComponent(Integer.toString(options.field_74335_Z)))));
        AbstractOption[] settings = null;
        if (ModernUIForge.isOptiFineLoaded()) {
            try {
                Field field = VideoSettingsScreen.class.getDeclaredField("videoOptions");
                field.setAccessible(true);
                settings = (AbstractOption[])field.get(null);
            }
            catch (Exception e) {
                ModernUI.LOGGER.error(ModernUI.MARKER, "Failed to be compatible with OptiFine video settings", (Throwable)e);
            }
        } else {
            settings = AccessVideoSettingsScreen.getOptions();
        }
        if (settings != null) {
            for (int i = 0; i < settings.length; ++i) {
                SliderPercentageOption option;
                if (settings[i] != AbstractOption.field_216713_t) continue;
                EventHandler.Client.NEW_GUI_SCALE = option = new SliderPercentageOption("options.guiScale", 0.0, 2.0, 1.0f, options -> options.field_74335_Z, (options, aDouble) -> {
                    if (options.field_74335_Z != aDouble.intValue()) {
                        options.field_74335_Z = aDouble.intValue();
                        Minecraft.func_71410_x().func_213226_a();
                    }
                }, (options, progressOption) -> options.field_74335_Z == 0 ? ((AccessOption)progressOption).callGenericValueLabel((ITextComponent)new TranslationTextComponent("options.guiScale.auto").func_230529_a_((ITextComponent)new StringTextComponent(" (" + (MuiHooks.C.calcGuiScales() >> 4 & 0xF) + ")"))) : ((AccessOption)progressOption).callGenericValueLabel((ITextComponent)new StringTextComponent(Integer.toString(options.field_74335_Z))));
                settings[i] = EventHandler.Client.NEW_GUI_SCALE;
                break;
            }
        } else {
            ModernUI.LOGGER.error(ModernUI.MARKER, "Failed to capture video settings");
        }
    }

    @Nonnull
    @OnlyIn(value=Dist.CLIENT)
    public static SoundEvent registerSound(@Nonnull IForgeRegistry<SoundEvent> registry, String name) {
        ResourceLocation soundID = new ResourceLocation(ModLoadingContext.get().getActiveNamespace(), name);
        SoundEvent event = (SoundEvent)new SoundEvent(soundID).setRegistryName(soundID);
        registry.register((IForgeRegistryEntry)event);
        return event;
    }

    @Nonnull
    public static <T extends Container> ContainerType<T> registerMenu(@Nonnull IForgeRegistry<ContainerType<?>> registry, IContainerFactory<T> factory, String name) {
        ContainerType type = IForgeContainerType.create(factory);
        type.setRegistryName(name);
        registry.register((IForgeRegistryEntry)type);
        return type;
    }
}

